---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-Cluster Manager Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行61-64（ReplacedRoute定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行77-92（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行78-79（ClusterStateRequest nodes=true）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行95-97（canTripCircuitBreaker false）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行100-108（テーブルヘッダー定義）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行111-131（buildTable処理）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行116（getClusterManagerNodeId）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行117-121（null時"-"出力）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行123-126（ノード情報出力）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` 行63（ReplacedRoute /_cat/master非推奨）
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行20（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/cluster_manager | E-01 | ○ |
| C-02 | /_cat/master は非推奨パス（ReplacedRoute） | E-10 | ○ |
| C-03 | ClusterStateRequest で nodes=true | E-03 | ○ |
| C-04 | canTripCircuitBreaker()がfalse | E-04 | ○ |
| C-05 | テーブルカラムは id, host, ip, node の4つ | E-05 | ○ |
| C-06 | host aliasは h | E-05 | ○ |
| C-07 | node aliasは n | E-05 | ○ |
| C-08 | クラスタマネージャ未選出時は全カラム"-" | E-08 | ○ |
| C-09 | 常に1行のみ出力 | E-06 | ○ |
| C-10 | getClusterManagerNodeId()でマネージャノードID取得 | E-07 | ○ |
| C-11 | nodes.get(id)でDiscoveryNode取得 | E-07 | ○ |
| C-12 | アクション名は cat_cluster_manager_action | E-01 | ○ |
| C-13 | ソースファイルは全132行 | E-06 | ○ |
| C-14 | 帳票名は「Cluster Manager Report」 | E-11 | ○ |
| C-15 | localパラメータ対応 | E-02 | ○ |
| C-16 | cluster:monitor/state 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・null判定・サーキットブレーカー設定（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] ReplacedRouteによる新旧パス定義が正確か確認
- [ ] canTripCircuitBreaker=falseの記述確認
- [ ] マネージャ未選出時の"-"出力確認
- [ ] セキュリティ権限名の確認
